<?php
// this class is taken (with permission) from goldbrick
// http://www.vbulletin.org/forum/showthread.php?t=150491&highlight=golbrick
//
// many thanks for that goes to the coder: @nix
//

class UMG_Media
{
	private $registry;

	private $info;

	private $regex_fields = array (
		'global' => array (
			'idregex'	 => array ('id', 'url'),
			'titleregex' => array ('title', 'content')
		),
		'custom' => array ()
	);

	private $format_fields = array (
		'global' => array (
			'srcformat'		   => array ('src',	     'id'),
			'thumbformat'	   => array ('thumb',	   'id'),
			'flashvarformat' => array ('flashvar', 'id')
		),
		'custom' => array ()
	);

	private $extensions = array (
		'flash'			    => array ('flv', 'swf', 'mp3'),
		'quick_time'	  => array ('mov', 'mpeg', 'mpg', 'mp4'),
		'real_media'	  => array ('rm', 'ra', 'rv', 'ram'),
		'windows_media'	=> array ('wma', 'wav', 'ogg', 'ape', 'mid', 'midi', 'asf', 'asx', 'wm', 'wmv'),
		'divx'			    => array ('divx', 'avi'),
		'adobe_pdf'		  => array ('pdf'),
		'image'			    => array ('gif', 'jpg', 'jpeg', 'bmp', 'png')
	);

	private $gb_options = array (
		'title',
		'width',
		'height',
		'autoplay',
		'loop'
	);

	private $db_fields = array (
		'width',
		'height',
		'widthpad',
		'title',
		'url',
		'src',
		'mime',
		'flashvar',
		'flashvarextra',
		'thumb',
		'loop',
		'extension',
		'site',
		'profile'
	);

	private $safe_fields = array (
		'info'			    => true, 
		'regex_fields'	=> false, 
		'format_fields' => false
	);

	private $existing = false;

	private $behaviours = array ('regex_fields', 'format_fields');

	private $debug;

	public function __construct (vB_Registry $registry, $debug = false)
	{
		$this->registry = $registry;
	}

	public function parse_url ($url, $gb_options = null)
	{
		if (!$identifier_site = $this->find_host_identifier ($url))
		{
			return false;
		}

		if ($identifier_site)
		{
			$identifier = $identifier_site;
			$this->load_config_values ($identifier, $gb_options);
			$this->info['site'] = $identifier;
		}
		else
		{
			return false;
		}

		$this->info['url']	= $url;

		if (!is_array ($identifier) AND !$this->is_valid_url ($url))
		{
			return false;
		}

		if (empty ($this->info['norequest']) AND $identifier_site)
		{
			$this->info['content'] = $this->open_site ($url);
		}

		if (!is_array ($identifier))
		{
			$this->exec_regex_fields(
				$this->get_settings_source ($identifier, 'regex')
			);

			$this->exec_format_fields(
				$this->get_settings_source ($identifier, 'format')
			);
		}

		if ($this->info['increase_size'])
		{
			$this->info['widthpad']		= $this->info['width'] + $this->info['increase_size'];
			$this->info['height']		= $this->info['height'] + $this->info['increase_size'];
		}

		return $this->info;
	}

	private function check_existing ($link)
	{
		return md5 ($link);
	}

	private function find_host_identifier ($url)
	{
		$matches = array ();
		preg_match ('/^(http:\/\/)?([^\/]+)/i', $url, $matches);
		
		$host  = preg_replace ('/^([\.a-z0-9]+)/', '$1', str_replace ('www.', '', $matches[2]));
		$parts = explode ('.', $host);

		if (file_exists (DIR . '/umg_gallery/media_sites/' . $parts[1] . '.php'))
		{
			return $parts[1];
		}
		
		if (file_exists (DIR . '/umg_gallery/media_sites/' . $parts[0] . '.php'))
		{
			return $parts[0];
		}
		
		return false;
	}

	protected function load_config_values ($identifier, $gb_options)
	{
		$changes = array ();
		
		$data	 = umg_cache_load_config ($identifier, array_keys ($this->safe_fields), $gb_options);
		
		foreach ($this->safe_fields as $field => $auto)
		{
			if (!isset ($data[$field]))
			{
				return;
			}

			if ($auto)
			{
				$this->$field = $data[$field];		
			}
			else if (in_array($field, $this->behaviours))
			{
				$this->{$field}['custom'][$identifier] = $data[$field];
			}
		}
	}
	
	private function is_valid_url ($url)
	{
		$settings = $this->get_settings_source ($this->info['site'], 'regex');
		if (isset ($this->info['validregex']))
		{
			$func  = 'array_values';
			$regex = $this->info['validregex'];
			unset ($this->info['validregex']);
		}	
		else if (isset ($this->info['idregex']) and $settings['idregex'][1] ==  'url')
		{
			$func  = 'array_keys';
			$regex = $this->info['idregex'];
		}
		else
		{
			return false;
		}

		if (is_array ($regex))
		{
			foreach ($func($regex) AS $expression)
			{
				if (preg_match ($expression, $url))
				{
					return true;
				}
			}	
			return false;
		}

		return preg_match ($regex, $url);
	}

	private function get_settings_source ($identifier, $type = 'regex')
	{
		$key = $type . '_fields';
		
		return	!empty ($this->{$key}['custom'][$identifier]) ? $this->{$key}['custom'][$identifier] : $this->{$key}['global'];
	}

	private function open_site ($url)
	{
		if (empty ($url))
		{
			$url = unhtmlspecialchars ($this->info['link']);
		}
		
		if (function_exists ('curl_init'))
		{
			$user_agent	 = 'Mozilla/5.0 (Macintosh; U; Intel Mac OS X; en-US; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11';
			$header[0]	 = "Accept: text/xml,application/xml,application/xhtml+xml,";
			$header[0]	.= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
			$header[] 	 = "Cache-Control: max-age=0";
			$header[]		 = "Connection: keep-alive";
			$header[]		 = "Keep-Alive: 300";
			$header[]		 = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
			$header[]		 = "Accept-Language: en-us,en;q=0.5";
		
			if ($this->info['header'])
			{
				$header[] = $this->info['header'];
			}

			$header[] = "Pragma: "; // browsers keep this blank.
			$handle = @curl_init ();

			@curl_setopt ($handle, CURLOPT_URL, $url);
			@curl_setopt ($handle, CURLOPT_USERAGENT, $user_agent);
			@curl_setopt ($handle, CURLOPT_HTTPHEADER, $header);
			@curl_setopt ($handle, CURLOPT_REFERER, 'http://www.google.com');
			@curl_setopt ($handle, CURLOPT_ENCODING, 'gzip,deflate');
			@curl_setopt ($handle, CURLOPT_FOLLOWLOCATION, true);
			@curl_setopt ($handle, CURLOPT_AUTOREFERER, true);
			@curl_setopt ($handle, CURLOPT_RETURNTRANSFER, 1);

			if ($this->info['postfield'])
			{
				@curl_setopt ($handle, CURLOPT_POSTFIELDS, $this->info['postfield']);
			}
			
			@curl_setopt ($handle, CURLOPT_TIMEOUT, 30);
			$content = @curl_exec ($handle);
			@curl_close ($handle);
		} 
		else if (@fclose(@fopen($url, 'r')) and @ini_get('allow_url_fopen')) 
		{
			$content = file($url);
			$content = implode('', $content);
		} 
		else 
		{
			return false;
		}

		return $content;
	}

	private function exec_regex_fields ($settings)
	{
		foreach ($settings AS $regexfield => $regexinfo)
		{
			list ($realfield, $var) = $regexinfo;

			if ($this->info[$regexfield])
			{
				if (!is_array ($this->info[$regexfield]))
				{
					$this->info[$regexfield] = array($this->info[$regexfield]);
				}

				foreach ($this->info[$regexfield] as $regex => $match)
				{
					$matches = null;
					if (preg_match ($regex, $this->info[$var], $matches))
					{
						$this->info[$realfield] = $matches[$match];
						break;
					}

				}
			}

			unset ($this->info[$regexfield]);
		}
	}

	private function exec_format_fields ($settings)
	{
		foreach ($settings AS $format_input => $formatinfo)
		{
			$format_output = array_shift ($formatinfo);

			$params = array ();
			foreach ($formatinfo AS $param)
			{
				$params[] = $this->info[$param];
			}

			unset ($formatinfo);

			if ($this->info[$format_input])
			{
				array_unshift ($params, $this->info[$format_input]);
				$this->info[$format_output] = @call_user_func_array ('sprintf', $params);
			}

			unset ($this->info[$format_input]);
		}
	}

}
?>